/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.client.ClientHelper;
import chanceCubes.commands.CCubesServerCommands;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.listeners.PlayerConnectListener;
import chanceCubes.listeners.TickListener;
import chanceCubes.network.CCubesPacketHandler;
import chanceCubes.rewards.DefaultGiantRewards;
import chanceCubes.rewards.DefaultRewards;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.StatsRegistry;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chancecubes")
public class CCubesCore {
    public static final String MODID = "chancecubes";
    public static final CreativeModeTab modTab = new CreativeModeTab("chancecubes"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)CCubesBlocks.CHANCE_CUBE);
        }
    };
    public static final Logger logger = LogManager.getLogger((String)"chancecubes");

    public CCubesCore() {
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certificate, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certificate, String str) {
                }
            }};
            context.init(null, trustManager, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonStart);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onIMCMessage);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientHelper::clientStart));
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigLoader.initParentFolder();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigLoader.configSpec, MODID + File.separatorChar + "chancecubes-server.toml");
    }

    public void commonStart(FMLCommonSetupEvent event) {
        CCubesPacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerConnectListener());
        MinecraftForge.EVENT_BUS.register((Object)new TickListener());
        event.enqueueWork(StatsRegistry::init);
    }

    @SubscribeEvent
    public void lootTableLoad(LootTableLoadEvent event) {
    }

    @SubscribeEvent
    public void serverStart(ServerStartingEvent event) {
        CCubesSettings.backupNRB.add(Blocks.f_50752_.m_49966_());
        CCubesSettings.backupNRB.add(Blocks.f_50080_.m_49966_());
        DefaultRewards.loadDefaultRewards();
        DefaultGiantRewards.loadDefaultRewards();
        CustomRewardsLoader.instance.loadCustomRewards();
        NonreplaceableBlockOverride.loadOverrides();
        logger.log(Level.INFO, "Death and destruction prepared! (And Cookies. Cookies were also prepared.)");
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        new CCubesServerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void onIMCMessage(InterModProcessEvent e) {
        e.getIMCStream().forEach(message -> {
            Object obj;
            Logger logger = LogManager.getLogger((String)MODID);
            if (message.method().equalsIgnoreCase("add-nonreplaceable") && (obj = message.messageSupplier().get()) instanceof BlockState) {
                BlockState state = (BlockState)obj;
                CCubesSettings.nonReplaceableBlocksIMC.add(state);
                logger.info(message.senderModId() + " has added the blockstate of \"" + state + "\" that Chance Cubes rewards will no longer replace.");
            }
        });
    }
}

